/*{
	"GUID":"2D0FCDC7-956B-469f-8E05-7B36CC2933FF"
}*/
#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
       __global FilterParam* param,
	   int alpha)  		// the gpu items/threads should be newW*newH
{	

	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	float2 iResolution = (float2)(W,H);
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = (vec2)(fragCoord.x + 0.5f, fragCoord.y + 0.5f)/iResolution.xy;
	
    vec4 color = INPUT(src_data, param, (vec2)(1.0f - tc.x,1.0f - tc.y));

	vec4 orig = INPUT(src_data, param, tc);
	
	write_imagef(dest_data, coordinate, orig*(1.0f - (float)alpha/100.0f) + color*(float)alpha/100.0f);
}
